#include <cmath>
#include <iostream>
#include <algorithm>
#include <vector>
using namespace std;

const int maxn = 105;
const int MAX_K = 100 * 100;

int n;
int p[maxn];

int lo[maxn], hi[maxn];

vector<int> check(int k) {
    int lo_sum = 0;
    int hi_sum = 0;
    vector<int> sol;
    int sum = 0;
    for (int i = 0; i < n; i++) {
        if (p[i] == 0)
            lo[i] = 0;
        else
            lo[i] = floor((double)k * (p[i] - 1) / 100) + 1;
        hi[i] = floor((double)k * p[i] / 100);
        lo_sum += lo[i];
        hi_sum += hi[i];
    }
    if (k < lo_sum || k > hi_sum)
        return sol;
    int extra = k - lo_sum;
    for (int i = 0; i < n; i++) {
        sol.push_back(min(lo[i] + extra, hi[i]));
        extra -= sol.back() - lo[i];
    }
    return sol;
}

int main() {
    ios::sync_with_stdio(false);
    cin >> n;
    for (int i = 0; i < n; i++)
        cin >> p[i];
    vector<int> sol;
    for (int i = 1; i <= MAX_K; i++) {
        sol = check(i);
        if (!sol.empty()) {
            cout << i << endl;
            break;
        }
    }
    if (sol.empty())
        cout << -1 << endl;
    else {
        for (int i = 0; i < n; i++)
            cout << sol[i] << ' ';
        cout << endl;
    }
    
   return 0;
}
